<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Lista extends Model 
{

    protected $table = 'listas';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function sender()
    {
        return $this->belongsTo('Sender');
    }

    public function marketings()
    {
        return $this->hasMany('Marketing', 'lista_id');
    }

    public function unsubscribes()
    {
        return $this->hasMany('Unsubscribe', 'lista_id');
    }

}