<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComputersTable extends Migration {

	public function up()
	{
		Schema::create('computers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('computer_status_id')->unsigned();
			$table->string('ip_address')->nullable();
			$table->string('import_notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('computers');
	}
}