<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->string('name', 191);
			$table->float('age');
			$table->integer('bloodtype_id')->unsigned();
			$table->integer('num_of_bags');
			$table->integer('city_id')->unsigned();
			$table->decimal('longtitude', 8,10);
			$table->decimal('latitude', 8,10);
			$table->string('phone');
			$table->longText('notes');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}