<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function cities()
	{
		return $this->hasOne('App\Models\City', 'city_id');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification', 'client_notification');
	}

	public function governates()
	{
		return $this->belongsToMany('App\Models\Governate');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Models\Post', 'post_client');
	}

	public function blood_types()
	{
		return $this->belongsToMany('App\Models\BloodType', 'bloodtype_client');
	}

	public function donation_requests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function getbloodtype()
	{
		return $this->belongsTo('App\Models\BloodType', 'blood_type_id');
	}

	public function cantacts()
	{
		return $this->hasMany('App\Models\Contact');
	}

}