<?php

namespace Post;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function author()
    {
        return $this->belongsTo('Author');
    }

    public function comments()
    {
        return $this->hasMany('Comment');
    }

    public function gallery()
    {
        return $this->hasMany('Gallery');
    }

}