<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePricesTable extends Migration {

	public function up()
	{
		Schema::create('prices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('tour_id')->unsigned()->nullable();
			$table->integer('single');
			$table->integer('double');
			$table->integer('triple');
			$table->integer('days');
			$table->enum('type', array('winter', 'summer'));
		});
	}

	public function down()
	{
		Schema::drop('prices');
	}
}