<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'email', 'password');

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function notificationts()
	{
		return $this->morphMany('App\Models\Notification');
	}

	public function tokens()
	{
		return $this->morphMany('App\Models\Token');
	}

}