<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->string('name', 255);
			$table->string('details', 255)->nullable();
			$table->decimal('price');
			$table->decimal('price_after_offer');
			$table->string('image', 255);
			$table->integer('duration_prepare')->nullable()->default('20');
			$table->integer('restaurant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}