<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191);
			$table->string('name_en', 191);
			$table->string('logo', 191);
			$table->enum('status', array('0', '1'));
			$table->string('subscription_contract', 191)->nullable();
			$table->string('menu', 191)->nullable();
			$table->enum('account_type', array('1', '2'));
			$table->float('nagez_commission')->default('0');
			$table->string('description', 500)->nullable();
			$table->string('manager_name', 191);
			$table->string('manager_phone', 191);
			$table->enum('special_status', array('0', '1'));
			$table->timestamps();
			$table->timestamps();
			$table->float('special_amount');
			$table->float('avg_rate')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}