<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlaceProductsTable extends Migration {

	public function up()
	{
		Schema::create('place_products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 191);
			$table->string('name_en', 191);
			$table->string('image', 191);
			$table->integer('place_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->float('price');
			$table->enum('status', array('0', '1'));
			$table->string('description_ar', 500);
			$table->string('description_en', 500);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('place_products');
	}
}