<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlaceOffersTable extends Migration {

	public function up()
	{
		Schema::create('place_offers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title_ar', 191);
			$table->string('title_en', 191);
			$table->string('description_ar', 500);
			$table->string('description_en', 500);
			$table->string('image', 191);
			$table->float('price');
			$table->timestamps();
			$table->timestamps();
			$table->integer('place_id')->unsigned();
			$table->enum('status', array('0', '1'));
			$table->integer('products_count')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('place_offers');
	}
}