<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('unit_count', 255);
			$table->enum('type_unit', array('day.month'));
			$table->decimal('price', 8,2);
			$table->text('summary')->nullable();
			$table->boolean('available_byshare')->default(0,1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}