<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Collection extends Model 
{

    protected $table = 'collections';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function collection()
    {
        return $this->belongsTo('Collection');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}