<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Match extends Eloquent {

	protected $table = 'matches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->belongsTo('App\Models\Group', 'group_id', 'id');
	}

	public function matcheType()
	{
		return $this->belongsTo('App\Models\User', 'match_type_id', 'id');
	}

	public function team()
	{
		return $this->belongsToMany('App\Models\Team');
	}

}