<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 50)->nullable();
			$table->string('country_code', 5)->default('966');
			$table->string('phone', 15)->unique();
			$table->string('email', 50)->unique()->nullable();
			$table->string('password', 100);
			$table->string('image', 50)->default('default.png');
			$table->boolean('active')->index()->default(0);
			$table->boolean('is_blocked')->index()->default(0);
			$table->boolean('is_approved')->index()->default(1);
			$table->string('lang', 2)->default('ar');
			$table->boolean('is_notify')->index()->default(1);
			$table->string('code', 10)->nullable();
			$table->timestamp('code_expire')->nullable();
			$table->decimal('lat', 10,8)->nullable();
			$table->decimal('lng', 10,8)->nullable();
			$table->string('map_desc', 50)->nullable();
			$table->string('socket_id', 191);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}