<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 50);
			$table->string('identity_number')->unique();
			$table->text('commercial_registration_number_or_work_permit');
			$table->string('country_code', 5)->default('966');
			$table->string('phone', 15)->unique();
			$table->string('password', 100)->nullable();
			$table->decimal('lat', 10,8);
			$table->decimal('lng', 10,8);
			$table->string('city', 191);
			$table->text('map_desc');
			$table->boolean('cell_phone_maintenance')->default(0);
			$table->boolean('store_services')->default(0);
			$table->boolean('mobile_maintenance')->default(0);
			$table->boolean('active')->default(1);
			$table->boolean('is_blocked')->default(0);
			$table->boolean('is_approved')->default(0);
			$table->boolean('is_notify')->default(1);
			$table->string('image', 50)->default('default.png');
			$table->string('email', 50)->unique()->nullable();
			$table->string('lang', 2)->default('ar');
			$table->string('socket_id', 191);
			$table->text('bio');
			$table->string('stc_number')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}