<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('gender', 'first_name', 'last_name', 'address', 'country', 'nationality', 'passport', 'curriculum_vitae', 'profil_picture', 'current_location', 'birth_date', 'birth_place', 'email_adress', 'password', 'availability', 'job_sector', 'experience', 'short_description', 'files', 'admin', 'notes');

	public function jobOffer()
	{
		return $this->hasMany('App\JobApplication');
	}

}