<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('cat_id')->unsigned()->nullable();
			$table->string('name');
			$table->string('slug');
			$table->text('content');
			$table->string('thumb', 1024);
			$table->string('meta_description', 1024);
			$table->integer('order');
			$table->timestamps();
			$table->integer('lang_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}