<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('complexe_id');
			$table->boolean('status')->nullable();
			$table->string('user_id');
			$table->timestamp('booking_at');
			$table->time('start_time_at');
			$table->time('end_time_at');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}