<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVacationsTable extends Migration {

	public function up()
	{
		Schema::create('vacations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('employee_id')->unsigned();
			$table->string('is_approved');
			$table->string('reason');
			$table->string('vacation_payment_desire');
			$table->integer('vacations_types_id')->unsigned();
			$table->enum('vacation_payment', array('paid', 'nonpaid'));
			$table->enum('type', array('annual', 'occasional', 'request'));
			$table->date('approved_date');
			$table->string('feed_back');
			$table->string('notes');
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('approved_by');
			$table->string('en_name');
			$table->string('ar_name');
			$table->integer('number_of_days');
		});
	}

	public function down()
	{
		Schema::drop('vacations');
	}
}