<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Outlets', function(Blueprint $table) {
			$table->foreign('districtid')->references('id')->on('Districts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('cateid')->references('id')->on('Categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Products_images', function(Blueprint $table) {
			$table->foreign('productid')->references('id')->on('Products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->foreign('districtid')->references('id')->on('Districts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->foreign('outletid')->references('id')->on('Outlets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->foreign('productid')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->foreign('size')->references('id')->on('Size')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Outlets', function(Blueprint $table) {
			$table->dropForeign('Outlets_districtid_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_cateid_foreign');
		});
		Schema::table('Products_images', function(Blueprint $table) {
			$table->dropForeign('Products_images_productid_foreign');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->dropForeign('Bookings_districtid_foreign');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->dropForeign('Bookings_outletid_foreign');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->dropForeign('Bookings_productid_foreign');
		});
		Schema::table('Bookings', function(Blueprint $table) {
			$table->dropForeign('Bookings_size_foreign');
		});
	}
}