<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('applications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('type', 255);
			$table->string('first_name');
			$table->string('last_name');
			$table->string('sex');
			$table->date('birthdate');
			$table->string('birthplace');
			$table->string('passport_number');
			$table->string('mothers_name');
			$table->string('phone');
			$table->string('contact_name');
			$table->string('contact_relationship');
			$table->string('contact_email');
			$table->string('contact_phone');
			$table->boolean('speaks_hungarian');
			$table->integer('application_period_id')->unsigned();
			$table->integer('citizenship')->unsigned();
			$table->integer('citizenship2')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('applications');
	}
}