<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Account extends Eloquent {

	protected $table = 'accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id');

	public function users()
	{
		return $this->hasMany('User', 'account_id');
	}

	public function stores()
	{
		return $this->hasMany('Store', 'account_id');
	}

}