<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('id');

    public function account()
    {
        return $this->belongsTo('Account', 'account_id');
    }

    public function orders()
    {
        return $this->hasMany('Order', 'user_id');
    }

    public function groups()
    {
        return $this->belongsToMany('Group', 'users_groups');
    }

}