<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model 
{

    protected $table = 'transactions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('store_id');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function order()
    {
        return $this->belongsTo('Order');
    }

    public function store()
    {
        return $this->belongsTo('Store');
    }

}