<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id');

    public function products()
    {
        return $this->belongsToMany('Product');
    }

    public function users()
    {
        return $this->belongsTo('User');
    }

}