<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Account extends Model 
{

    protected $table = 'accounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id');

    public function users()
    {
        return $this->hasMany('User', 'account_id');
    }

    public function stores()
    {
        return $this->hasMany('Store', 'account_id');
    }

}