<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reservation extends Eloquent {

	protected $table = 'reservations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function listing()
	{
		return $this->belongsTo('App\Listing');
	}

	public function conversations()
	{
		return $this->hasMany('App\Conversation');
	}

}