<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidatesTable extends Migration {

	public function up()
	{
		Schema::create('candidates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('gender_id')->unsigned();
			$table->string('first_name', 255);
			$table->string('surname', 255);
			$table->string('email', 255);
			$table->string('password', 128);
			$table->integer('location_id')->unsigned();
			$table->string('email2', 255)->nullable();
			$table->integer('how_find_id')->unsigned();
			$table->string('how_find_other', 100)->nullable();
			$table->date('date_of_birth')->nullable();
			$table->integer('nationality_1_id')->unsigned();
			$table->integer('nationality_2_id')->unsigned()->nullable();
			$table->boolean('marital_status')->nullable()->default(0);
			$table->integer('military_status_id')->unsigned()->default('1');
			$table->boolean('has_degree')->nullable()->default(0);
			$table->integer('field_of_study_id')->unsigned()->default('1');
			$table->integer('english_knowledge_level_id')->unsigned()->default('1');
			$table->boolean('mailshot_career_related_news')->default(1);
			$table->boolean('mailshot_event_product_service')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('candidates');
	}
}