<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Skill extends Model 
{

    protected $table = 'candidate_cv_skills';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cv_id', 'title', 'skill_level_id', 'skill_type_id');

    public function cv()
    {
        return $this->belongsTo('App\CandidateCV', 'cv_id');
    }

    public function skillLevel()
    {
        return $this->belongsTo('App\Lookup', 'skill_level_id');
    }

}