<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CurrentEmployment extends Model 
{

    protected $table = 'candidate_cv_current_employment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cv_id', 'title', 'job_category_id', 'seniority_id', 'campany_name', 'location_id', 'industry_id', 'company_size_id', 'company_nationality_type_id', 'net_salary', 'salary_currency_type_id', 'salary_period_id', 'cash_benefits', 'benefit_period_id', 'other_benefits');

    public function cv()
    {
        return $this->belongsTo('App\CandidateCV', 'cv_id');
    }

    public function jobCategory()
    {
        return $this->belongsTo('App\Lookup', 'job_category_id');
    }

    public function seniority()
    {
        return $this->belongsTo('App\Lookup', 'seniority_id');
    }

    public function location()
    {
        return $this->belongsTo('App\Lookup', 'location_id');
    }

    public function industry()
    {
        return $this->belongsTo('App\Lookup', 'industry_id');
    }

    public function companySize()
    {
        return $this->belongsTo('App\Lookup', 'company_size_id');
    }

    public function salaryCurrency()
    {
        return $this->belongsTo('App\Lookup', 'salary_currency_type_id');
    }

    public function salaryPeriod()
    {
        return $this->belongsTo('App\Lookup', 'salary_period_id');
    }

    public function benefitPeriod()
    {
        return $this->belongsTo('App\Lookup', 'benefit_period_id');
    }

    public function nationalityType()
    {
        return $this->belongsTo('App\Lookup', 'company_nationality_type_id');
    }

}