<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('NONE', 'INIT', 'PAYMENT', 'DEBIT', 'CREDIT'))->index();
			$table->string('transaction_id')->index();
			$table->string('contact_number')->index();
			$table->datetime('execute_date')->index();
			$table->enum('status', array('NONE', 'VOID', 'DONE', 'PENDING', 'ERROR', 'REJECTED'))->index();
			$table->decimal('amount');
			$table->integer('payment_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}