<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class EquipmentParcel extends Model 
{

    protected $table = 'equipment_parcels';
    public $timestamps = true;

    public function adress()
    {
        return $this->belongsTo('Adress');
    }

    public function status()
    {
        return $this->belongsTo('EquipmentReservation');
    }

    public function routes()
    {
        return $this->hasMany('EquipmentRoute');
    }

    public function reservation()
    {
        return $this->belongsTo('EquipmentReservation');
    }

    public function group()
    {
        return $this->belongsTo('Group');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function validateBy()
    {
        return $this->belongsTo('User');
    }

    public function bill()
    {
        return $this->belongsTo('Bill');
    }

}