<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Wishlist extends Eloquent {

	protected $table = 'wishlist';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'requirement_id');

	public function requirement()
	{
		return $this->belongsTo('HouseRequirement', 'requirement_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}