<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('gender', 'id_number', 'country_id', 'phone', 'biography_en', 'biography_ar', 'house_id', 'join_date', 'username');

	public function house()
	{
		return $this->belongsTo('House', 'house_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}