<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreProduct extends Eloquent {

	protected $table = 'store_product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id', 'name_en', 'name_ar', 'price', 'link', 'category_id');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}