<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Store extends Eloquent {

	protected $table = 'store';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar');

	public function products()
	{
		return $this->hasMany('StoreProduct', 'store_id');
	}

}