<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrphanSibling extends Eloquent {

	protected $table = 'orphan_sibling';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('orphan_id', 'name_en', 'name_ar', 'relative_status');

	public function orphan()
	{
		return $this->belongsTo('Orphan', 'orphan_id');
	}

}