<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrphanTable extends Migration {

	public function up()
	{
		Schema::create('orphan', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('house_id')->nullable();
			$table->string('name_en', 255)->nullable();
			$table->string('name_ar', 255)->nullable();
			$table->date('birth_date')->nullable();
			$table->string('birth_place', 255)->nullable();
			$table->string('orphan_condition', 255)->nullable();
			$table->string('parents_condition', 255)->nullable();
			$table->tinyInteger('live_with_family')->nullable();
			$table->text('colleagues')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orphan');
	}
}