<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHouseServiceTable extends Migration {

	public function up()
	{
		Schema::create('house_service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('house_id')->nullable();
			$table->string('name_en', 255)->nullable();
			$table->string('name_ar', 255)->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->decimal('cost_min', 10,2)->nullable();
			$table->decimal('cost_max', 10,2)->nullable();
			$table->tinyInteger('is_urgent')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('house_service');
	}
}