<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('gender', 20)->nullable();
			$table->string('id_number', 50)->nullable();
			$table->integer('country_id')->nullable();
			$table->string('phone', 20)->nullable();
			$table->text('biography_en')->nullable();
			$table->text('biography_ar')->nullable();
			$table->integer('house_id')->nullable();
			$table->date('join_date')->nullable();
			$table->string('username', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}