<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HouseRequirement extends Model 
{

    protected $table = 'house_requirement';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('house_id', 'orphan_id', 'type', 'store_id', 'product_id', 'category_id', 'total_price', 'quantity');

    public function house()
    {
        return $this->belongsTo('House', 'house_id');
    }

    public function orphan()
    {
        return $this->belongsTo('Orphan', 'orphan_id');
    }

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function product()
    {
        return $this->belongsTo('StoreProduct', 'product_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

}