<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nickname');
			$table->string('avatar');
			$table->string('cover_image');
			$table->string('fullname');
			$table->string('email');
			$table->string('password');
			$table->string('phone');
			$table->datetime('birthdate');
			$table->boolean('verified')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}