<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('Post', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->string('job_category', 50)->nullable();
			$table->string('position', 100)->nullable();
			$table->string('country', 50)->nullable();
			$table->string('state', 50)->nullable();
			$table->string('city', 50)->nullable();
			$table->text('requirements')->nullable();
			$table->text('desc')->nullable();
			$table->string('gender', 1)->nullable();
			$table->smallInteger('age_from')->nullable()->default('0');
			$table->smallInteger('age_to')->nullable()->default('0');
			$table->smallInteger('experience_years')->nullable()->default('0');
			$table->string('job_type', 20)->nullable();
			$table->string('seniority_level', 20)->nullable();
			$table->string('english_ability', 20)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Post');
	}
}