<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostCanAc extends Model 
{

    protected $table = 'post_candidate_activity';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function post()
    {
        return $this->belongsTo('Post', 'id');
    }

    public function candidateProfile()
    {
        return $this->belongsTo('App\/Candidate\Profile', 'user_id');
    }

}