<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('store_id')->unsigned();
			$table->string('name', 191);
			$table->string('mobile', 191)->unique();
			$table->string('password', 255);
			$table->string('father_name', 191);
			$table->string('mother_name', 191);
			$table->string('national_id', 191)->unique();
			$table->enum('type', array('admin', 'user'));
			$table->text('address');
			$table->rememberToken();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}