<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStocksTable extends Migration {

	public function up()
	{
		Schema::create('stocks', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('stock_type', array('in', 'out'));
			$table->integer('sales_id')->unsigned()->nullable();
			$table->integer('purchase_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->integer('product_id')->unsigned()->nullable();
			$table->double('quantity', 10,2);
			$table->double('buying_price', 10,2)->default('0');
			$table->double('selling_price', 10,2)->default('0');
			$table->double('subtotal', 10,2)->default('0');
			$table->double('total_vat', 10,2)->default('0');
			$table->double('total_discount', 10,2)->default('0');
			$table->integer('store_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stocks');
	}
}