<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBeneficiariesTable extends Migration {

	public function up()
	{
		Schema::create('Beneficiaries', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('userInfo_id')->unsigned();
			$table->string('membership_id');
			$table->date('date_of_birth');
			$table->integer('id_number')->nullable();
			$table->date('id_date')->nullable();
			$table->string('id_occupation');
			$table->string('marital_status');
			$table->string('education_level');
			$table->string('major');
			$table->string('address');
			$table->string('house_ownership');
			$table->string('house_type');
			$table->integer('family_members')->nullable();
			$table->integer('family_male_members');
			$table->string('family_female_members');
			$table->integer('rank_in_family');
			$table->integer('nationality_id')->unsigned();
			$table->string('father_occupation');
			$table->date('filling_form_date')->nullable();
			$table->string('full_name');
			$table->text('health_status');
			$table->text('health_description')->nullable();
			$table->string('koshak_sega_number')->nullable();
			$table->string('koshak_etimad')->nullable();
			$table->string('koshak_vehicle_type')->nullable();
			$table->string('koshak_toreed_office')->nullable();
			$table->string('koshak_driver_name')->nullable();
			$table->integer('koshak_mobile_number')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Beneficiaries');
	}
}