<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Adherents', function(Blueprint $table) {
			$table->foreign('user-id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Adherents', function(Blueprint $table) {
			$table->foreign('role-id')->references('id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Adherent_cotisation', function(Blueprint $table) {
			$table->foreign('adherent-id')->references('id')->on('Adherents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Adherent_cotisation', function(Blueprint $table) {
			$table->foreign('cotisation-id')->references('id')->on('Cotisation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Adherents', function(Blueprint $table) {
			$table->dropForeign('Adherents_user-id_foreign');
		});
		Schema::table('Adherents', function(Blueprint $table) {
			$table->dropForeign('Adherents_role-id_foreign');
		});
		Schema::table('Adherent_cotisation', function(Blueprint $table) {
			$table->dropForeign('Adherent_cotisation_adherent-id_foreign');
		});
		Schema::table('Adherent_cotisation', function(Blueprint $table) {
			$table->dropForeign('Adherent_cotisation_cotisation-id_foreign');
		});
	}
}