<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRealisationsTable extends Migration {

	public function up()
	{
		Schema::create('Realisations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->float('real_resultat');
			$table->float('real_prod');
			$table->integer('annee');
			$table->enum('mois', array('Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'));
			$table->integer('filiale_id')->unsigned();
			$table->boolean('valide');
		});
	}

	public function down()
	{
		Schema::drop('Realisations');
	}
}